﻿Imports System
Imports System.Collections.Generic
Imports System.Text
Imports System.Runtime.InteropServices
Imports System.Windows.Forms
Imports System.Drawing
Namespace Printer
    Public Class PrinterState
        Public Shared ReadOnly STS_NORMAL As UInteger = &H0
        Public Shared ReadOnly STS_PAPEREMPTY As UInteger = 1
        Public Shared ReadOnly STS_COVEROPEN As UInteger = 2
        Public Shared ReadOnly STS_PAPERNEAREND As UInteger = 4
        Public Shared ReadOnly STS_MSR_READY As UInteger = 8
        Public Shared ReadOnly STS_SMARTCARD_READY As UInteger = 16
        Public Shared ReadOnly STS_ERROR As UInteger = 32
        Public Shared ReadOnly STS_NOT_OPEN As UInteger = 64
        Public Shared ReadOnly STS_OFFLINE As UInteger = 128
        Private m_status As UInteger = 0
        Public Sub New()
            m_status = 0
        End Sub
        Public Property State() As UInteger
            Get
                Return m_status
            End Get
            Set(ByVal value As UInteger)
                m_status = value
            End Set
        End Property
        Public ReadOnly Property IsNormal() As Boolean
            Get
                Return (STS_NORMAL = m_status)
            End Get
        End Property
        Public ReadOnly Property InError() As Boolean
            Get
                Return (PAPEREMPTY OrElse COVEROPEN OrElse PAPERNEAREND OrElse MSR_READY OrElse SMARTCARD_READY OrElse [ERROR] OrElse NOT_OPEN OrElse OFFLINE)
            End Get
        End Property
        Public ReadOnly Property PAPEREMPTY() As Boolean
            Get
                Return ((STS_PAPEREMPTY And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property COVEROPEN() As Boolean
            Get
                Return ((STS_COVEROPEN And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property PAPERNEAREND() As Boolean
            Get
                Return ((STS_PAPERNEAREND And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property MSR_READY() As Boolean
            Get
                Return ((STS_MSR_READY And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property SMARTCARD_READY() As Boolean
            Get
                Return ((STS_SMARTCARD_READY And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property [ERROR]() As Boolean
            Get
                Return ((STS_ERROR And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property NOT_OPEN() As Boolean
            Get
                Return ((STS_NOT_OPEN And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property OFFLINE() As Boolean
            Get
                Return ((STS_OFFLINE And m_status) > 0)
            End Get
        End Property
    End Class
    Public Class DemoPrinter
        Public Const DLLDIR As String = "ZPL_SDK.dll"
        Public Const charSet As CharSet = charSet.Ansi
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function PrinterCreator(ByRef printer As IntPtr, ByVal model As String) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function PrinterCreatorS(ByVal model As String) As Point
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function PrinterDestroy(ByVal printer As IntPtr) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function PortOpen(ByVal printer As IntPtr, ByVal ioSetting As String) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function PortClose(ByVal printer As IntPtr) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function WriteData(ByVal printer As IntPtr, ByVal data As Byte(), ByVal writeNum As Integer) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ReadData(ByVal printer As IntPtr, ByVal data As Byte(), ByVal readNum As Integer, ByRef preadedNum As Integer)
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function DirectIO(ByVal printer As IntPtr, ByVal writeData As Byte(), ByVal writeNum As Integer, ByVal readData As Byte(), ByVal readNum As Integer, ByRef preadedNum As Integer) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_StartFormat(ByVal printer As IntPtr) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_EndFormat(ByVal printer As IntPtr) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_SetChangeFontEncoding(ByVal printer As IntPtr, ByVal encodetype As Integer) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_Text(ByVal printer As IntPtr, ByVal xPos As Integer, ByVal yPos As Integer, ByVal fontNum As Integer, ByVal orientation As Integer, ByVal fontWidth As Integer, ByVal fontHeight As Integer, ByVal text As String) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_BarCode39(ByVal printer As IntPtr, ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal moduleWidth As Integer, ByVal codeHeight As Integer, ByVal line As Char, ByVal lineAboveCode As Char, ByVal digit As Char, ByVal text As String) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_Pdf417(ByVal printer As IntPtr, ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal moduleWidth As Integer, ByVal codeHeight As Integer, ByVal securityLevel As Integer, ByVal column As Integer, ByVal rows As Integer, ByVal truncate As Char, ByVal text As String) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_CodeEan8(ByVal printer As IntPtr, ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal moduleWidth As Integer, ByVal codeHeight As Integer, ByVal line As Char, ByVal lineAboveCode As Char, ByVal text As String) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_QRCode(ByVal printer As IntPtr, ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal model As Integer, ByVal dpi As Integer, ByVal eccLevel As Char, ByVal input As Char, ByVal charMode As Char, ByVal text As String) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_UpcExtensions(ByVal printer As IntPtr, ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal moduleWidth As Integer, ByVal codeHeight As Integer, ByVal line As Char, ByVal lineAboveCode As Char, ByVal text As String) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_UpcaBarcode(ByVal printer As IntPtr, ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal moduleWidth As Integer, ByVal codeHeight As Integer, ByVal line As Char, ByVal lineAboveCode As Char, ByVal digit As Char, ByVal text As String) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_GraphicBox(ByVal printer As IntPtr, ByVal xPos As Integer, ByVal yPos As Integer, ByVal width As Integer, ByVal height As Integer, ByVal thickness As Integer, ByVal rounding As Integer) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_GraphicCircle(ByVal printer As IntPtr, ByVal xPos As Integer, ByVal yPos As Integer, ByVal diameter As Integer, ByVal thickness As Integer) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_GraphicDiagonalLine(ByVal printer As IntPtr, ByVal xPos As Integer, ByVal yPos As Integer, ByVal width As Integer, ByVal height As Integer, ByVal thickness As Integer, ByVal orientation As Integer) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_GraphicEllipse(ByVal printer As IntPtr, ByVal xPos As Integer, ByVal yPos As Integer, ByVal width As Integer, ByVal height As Integer, ByVal thickness As Integer) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_PrintImage(ByVal printer As IntPtr, ByVal xPos As Integer, ByVal yPos As Integer, ByVal imgName As String) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_GraphicSymbol(ByVal printer As IntPtr, ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal width As Integer, ByVal height As Integer, ByVal type As String) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_SetDiagnosticsMode(ByVal printer As IntPtr, ByVal isEnable As Integer) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_SetPrintOrientation(ByVal printer As IntPtr, ByVal orientation As Integer) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_SetPrintWidth(ByVal printer As IntPtr, ByVal width As Integer) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_SetPrintRate(ByVal printer As IntPtr, ByVal printSpeed As Integer, ByVal slewSpeed As Integer, ByVal backfeedSpeed As Integer) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_SetPrintDarkness(ByVal printer As IntPtr, ByVal darkness As Integer) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_PrintConfigurationLabel(ByVal printer As IntPtr) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_SetPrintMode(ByVal printer As IntPtr, ByVal mode As Char, ByVal prePeelSelect As Char) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_SetPrintQuantity(ByVal printer As IntPtr, ByVal totalQuantity As Integer, ByVal pauseAndCutValue As Integer, ByVal replicatesOfEachSerialNumber As Integer, ByVal overridePauseCount As Char) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_RfidWrite(ByVal printer As IntPtr, ByVal format As Char, ByVal begin As Integer, ByVal size As Integer, ByVal memoryBlock As Integer, ByVal text As String) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_RfidRead(ByVal printer As IntPtr, ByVal format As Char, ByVal begin As Integer, ByVal size As Integer, ByVal memoryBlock As Integer, ByVal headText As String, ByVal tailText As String) As Integer
        End Function
        <DllImport(DLLDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function ZPL_RfidCalibration(ByVal printer As IntPtr) As Integer
        End Function
        Private printer As IntPtr
        Private E_SUCCESS As Integer = Constants.E_SUCCESS
        Private E_INVALID_PARAMETER As Integer = Constants.E_INVALID_PARAMETER
        Private state As New PrinterState()
        Private result As Integer = 0
        Public Function DemoPrinterCreator(ByVal name As String) As Integer
            Return PrinterCreator(printer, name)
        End Function
        Public Function DemoPortOpen(ByVal uri As String) As Integer
            If printer <> IntPtr.Zero Then
                result = PortOpen(printer, uri)
                Return result
            Else
                Return Constants.E_BAD_HANDLE
            End If
        End Function
        Public Function DemoPrinterDestroy() As Integer
            Return PrinterDestroy(printer)
        End Function
        Public Function DemoPortClose() As Integer
            Return PortClose(printer)
        End Function
        Public Function DemoWriteData(ByVal data As Byte(), ByVal writeNum As Integer) As Integer
            Return WriteData(printer, data, writeNum)
        End Function
        Public Function DemoReadData(ByVal data As Byte(), ByVal readNum As Integer, ByRef preadedNum As Integer) As Integer
            Return ReadData(printer, data, readNum, preadedNum)
        End Function
        Public Function DemoDirectIO(ByVal writeData As Byte(), ByVal writeNum As IntPtr, ByVal readData As Byte(), ByVal readNum As IntPtr, ByRef preadedNum As IntPtr) As Integer
            Return DirectIO(printer, writeData, writeNum, readData, readNum, preadedNum)
        End Function
        Public Function DemoStartFormat() As Integer
            Return ZPL_StartFormat(printer)
        End Function
        Public Function DemoEndFormat() As Integer
            Return ZPL_EndFormat(printer)
        End Function
        Public Function DemoSetChangeFontEncoding(ByVal encodetype As Integer) As Integer
            Return ZPL_SetChangeFontEncoding(printer, encodetype)
        End Function
        Public Function DemoText(ByVal xPos As Integer, ByVal yPos As Integer, ByVal fontNum As Integer, ByVal orientation As Integer, ByVal fontWidth As Integer, ByVal fontHeight As Integer, ByVal text As String) As Integer
            Return ZPL_Text(printer, xPos, yPos, fontNum, orientation, fontWidth, fontHeight, text)
        End Function
        Public Function DemoBarCode39(ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal moduleWidth As Integer, ByVal codeHeight As Integer, ByVal line As Char, ByVal lineAboveCode As Char, ByVal digit As Char, ByVal text As String) As Integer
            Return ZPL_BarCode39(printer, xPos, yPos, orientation, moduleWidth, codeHeight, line, lineAboveCode, digit, text)
        End Function
        Public Function DemoPdf417(ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal moduleWidth As Integer, ByVal codeHeight As Integer, ByVal securityLevel As Integer, ByVal column As Integer, ByVal rows As Integer, ByVal truncate As Char, ByVal text As String) As Integer
            Return ZPL_Pdf417(printer, xPos, yPos, orientation, moduleWidth, codeHeight, securityLevel, column, rows, truncate, text)
        End Function
        Public Function DemoCodeEan8(ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal moduleWidth As Integer, ByVal codeHeight As Integer, ByVal line As Char, ByVal lineAboveCode As Char, ByVal text As String) As Integer
            Return ZPL_CodeEan8(printer, xPos, yPos, orientation, moduleWidth, codeHeight, line, lineAboveCode, text)
        End Function
        Public Function DemoQRCode(ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal model As Integer, ByVal dpi As Integer, ByVal eccLevel As Char, ByVal input As Char, ByVal charMode As Char, ByVal text As String) As Integer
            Return ZPL_QRCode(printer, xPos, yPos, orientation, model, dpi, eccLevel, input, charMode, text)
        End Function
        Public Function DemoUpcExtensions(ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal moduleWidth As Integer, ByVal codeHeight As Integer, ByVal line As Char, ByVal lineAboveCode As Char, ByVal text As String) As Integer
            Return ZPL_UpcExtensions(printer, xPos, yPos, orientation, moduleWidth, codeHeight, line, lineAboveCode, text)
        End Function
        Public Function DemoUpcaBarcode(ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal moduleWidth As Integer, ByVal codeHeight As Integer, ByVal line As Char, ByVal lineAboveCode As Char, ByVal digit As Char, ByVal text As String) As Integer
            Return ZPL_UpcaBarcode(printer, xPos, yPos, orientation, moduleWidth, codeHeight, line, lineAboveCode, digit, text)
        End Function
        Public Function DemoGraphicBox(ByVal xPos As Integer, ByVal yPos As Integer, ByVal width As Integer, ByVal height As Integer, ByVal thickness As Integer, ByVal rounding As Integer) As Integer
            Return ZPL_GraphicBox(printer, xPos, yPos, width, height, thickness, rounding)
        End Function
        Public Function DemoGraphicCircle(ByVal xPos As Integer, ByVal yPos As Integer, ByVal diameter As Integer, ByVal thickness As Integer) As Integer
            Return ZPL_GraphicCircle(printer, xPos, yPos, diameter, thickness)
        End Function
        Public Function DemoGraphicDiagonalLine(ByVal xPos As Integer, ByVal yPos As Integer, ByVal width As Integer, ByVal height As Integer, ByVal thickness As Integer, ByVal orientation As Integer) As Integer
            Return ZPL_GraphicDiagonalLine(printer, xPos, yPos, orientation, width, height, thickness)
        End Function
        Public Function DemoGraphicEllipse(ByVal xPos As Integer, ByVal yPos As Integer, ByVal width As Integer, ByVal height As Integer, ByVal thickness As Integer) As Integer
            Return ZPL_GraphicEllipse(printer, xPos, yPos, width, height, thickness)
        End Function
        Public Function DemoPrintImage(ByVal xPos As Integer, ByVal yPos As Integer, ByVal imgName As String) As Integer
            Return ZPL_PrintImage(printer, xPos, yPos, imgName)
        End Function
        Public Function DemoGraphicSymbol(ByVal xPos As Integer, ByVal yPos As Integer, ByVal orientation As Integer, ByVal width As Integer, ByVal height As Integer, ByVal type As String) As Integer
            Return ZPL_GraphicSymbol(printer, xPos, yPos, orientation, width, height, type)
        End Function
        Public Function DemoSetDiagnosticsMode(ByVal isEnable As Integer) As Integer
            Return ZPL_SetDiagnosticsMode(printer, isEnable)
        End Function
        Public Function DemoSetPrintOrientation(ByVal orientation As Integer) As Integer
            Return ZPL_SetPrintOrientation(printer, orientation)
        End Function
        Public Function DemoSetPrintWidth(ByVal width As Integer) As Integer
            Return ZPL_SetPrintWidth(printer, width)
        End Function
        Public Function DemoSetPrintRate(ByVal printSpeed As Integer, ByVal slewSpeed As String, ByVal backfeedSpeed As Integer) As Integer
            Return ZPL_SetPrintRate(printer, printSpeed, slewSpeed, backfeedSpeed)
        End Function
        Public Function DemoSetPrintDarkness(ByVal darkness As Integer) As Integer
            Return ZPL_SetPrintDarkness(printer, darkness)
        End Function
        Public Function DemoPrintConfigurationLabel() As Integer
            Return ZPL_PrintConfigurationLabel(printer)
        End Function
        Public Function DemoSetPrintMode(ByVal mode As Char, ByVal prePeelSelect As Char) As Integer
            Return ZPL_SetPrintMode(printer, mode, prePeelSelect)
        End Function
        Public Function DemoSetPrintQuantity(ByVal totalQuantity As Integer, ByVal pauseAndCutValue As Integer, ByVal replicatesOfEachSerialNumber As Integer, ByVal overridePauseCount As Char) As Integer
            Return ZPL_SetPrintQuantity(printer, totalQuantity, pauseAndCutValue, replicatesOfEachSerialNumber, overridePauseCount)
        End Function
        Public Function DemoRfidWrite(ByVal format As Char, ByVal begin As Integer, ByVal size As Integer, ByVal memoryBlock As Integer, ByVal text As String) As Integer
            Return ZPL_RfidWrite(printer, format, begin, size, memoryBlock, text)
        End Function
        Public Function DemoRfidRead(ByVal format As Char, ByVal begin As Integer, ByVal size As Integer, ByVal memoryBlock As Integer, ByVal headText As String, ByVal tailText As String) As Integer
            Return ZPL_RfidRead(printer, format, begin, size, memoryBlock, headText, tailText)
        End Function
        Public Function DemoRfidCalibration() As Integer
            Return ZPL_RfidCalibration(printer)
        End Function

    End Class
End Namespace